#include<bits/stdc++.h>
using namespace std;

using ll = long long;
namespace pcf {
  // initialize once by calling init()
  #define MAXN 10000010 // initial sieve limit
  #define MAX_PRIMES 1000010 // max size of the prime array for sieve
  #define PHI_N 100000
  #define PHI_K 100

  int len = 0; // total number of primes generated by sieve
  int primes[MAX_PRIMES];
  int pref[MAXN]; // pref[i] --> number of primes <= i
  int dp[PHI_N][PHI_K]; // precal of yo(n,k)
  bitset <MAXN> f;
  void sieve(int n) {
    f[1] = true;
    for (int i = 4; i <= n; i += 2) f[i] = true;
    for (int i = 3; i * i <= n; i += 2) {
      if (!f[i]) {
        for (int j = i * i; j <= n; j += i << 1) f[j] = 1;
      }
    }
    for (int i = 1; i <= n; i++) {
      if (!f[i]) primes[len++] = i;
      pref[i] = len;
    }
  }
  void init() {
    sieve(MAXN - 1);
    // precalculation of phi upto size (PHI_N,PHI_K)
    for (int n = 0; n < PHI_N; n++) dp[n][0] = n;
    for (int k = 1; k < PHI_K; k++) {
      for (int n = 0; n < PHI_N; n++) {
        dp[n][k] = dp[n][k - 1] - dp[n / primes[k - 1]][k - 1];
      }
    }
  }
  // returns the number of integers less or equal n which are
  // not divisible by any of the first k primes
  // recurrence --> yo(n, k) = yo(n, k-1) - yo(n / p_k , k-1)
  // for sum of primes yo(n, k) = yo(n, k-1) - p_k * yo(n / p_k , k-1)
  long long yo(long long n, int k) {
    if (n < PHI_N && k < PHI_K) return dp[n][k];
    if (k == 1) return ((++n) >> 1);
    if (primes[k - 1] >= n) return 1;
    return yo(n, k - 1) - yo(n / primes[k - 1], k - 1);
  }
  // complexity: n^(2/3).(log n^(1/3))
  long long Legendre(long long n) {
    if (n < MAXN) return pref[n];
    int lim = sqrt(n) + 1;
    int k = upper_bound(primes, primes + len, lim) - primes;
    return yo(n, k) + (k - 1);
  }
  // runs under 0.5s for n = 1e12
  long long Lehmer(long long n) {
    if (n < MAXN) return pref[n];
    long long w, res = 0;
    int b = sqrt(n), c = Lehmer(cbrt(n)), a = Lehmer(sqrt(b)); b = Lehmer(b);
    res = yo(n, a) + ((1LL * (b + a - 2) * (b - a + 1)) >> 1);
    for (int i = a; i < b; i++) {
      w = n / primes[i];
      int lim = Lehmer(sqrt(w)); res -= Lehmer(w);
      if (i <= c) {
        for (int j = i; j < lim; j++) {
          res += j;
          res -= Lehmer(w / primes[j]);
        }
      }
    }
    return res;
  }
}
using namespace pcf;
const ll inf = 1e12 + 9; // > max n
const int M = 2020; // maximum number of divisors
const int C = 1010; // 4th root of max n
const int L = 41; // 2^L >= max n
ll pw[C][L]; int s[M]; 
ll power(ll n, int k) {
  if (k >= L) return inf;
  if (n < C) return pw[n][k];
  if (k == 1) return n;
  if (k == 2) return n * n;
  if (k == 3) return n * n * n;
  return inf;
}
vector<int> d[M];
// returns the count of numbers <= n s.t. each has exactly k divisors and isn't divisible by the first 'last' primes
// pretty fast!
ll backtrack(ll n, int k, int last = 0) {
  if (k >= M) return 0;
  if (n <= 0) return 0;
  if (k == 1) return 1;
  if (n == 1) return 0;
  if (k == 2) return max(0LL, Lehmer(n) - last);
  if (d[k].size() == 1) {
    if (d[k][0] - 1 >= L) return 0;
    if (power(primes[last], d[k][0] - 1) > n) return 0;
    int ans = last - 1, l = last, r = pow(n, 1.0 / (d[k][0] - 1)) + 1;
    while (l <= r) {
      int mid = (l + r) >> 1;
      ll p = power(primes[mid], d[k][0] - 1);
      if (p > n) r = mid - 1;
      else l = mid + 1, ans = mid;
    }
    return ans - last + 1;
  }
  ll ans = 0;
  for (auto x: d[k]) {
    for (int i = last; i < len; i++) {
      ll p = power(primes[i], x - 1);
      if (p > n) break;
      if (k / x == 1) {
        ++ans;
        continue;
      }
      if (power(primes[i + 1], s[k / x]) > n / p) break;
      ans += backtrack(n / p, k / x, i + 1);
    }
  }
  return ans;
}
int32_t main() {
  ios_base::sync_with_stdio(0);
  cin.tie(0);
  init();
  for (int i = 2; i < M; i++) {
    for (int j = i; j < M; j += i) {
      d[j].push_back(i);
    }
    reverse(d[i].begin(), d[i].end());
    for (int j = 0; j < len; j++) {
      if (primes[j] > i) break;
      int cur = i;
      while (cur % primes[j] == 0) {
        cur /= primes[j];
        s[i] += primes[j] - 1;
      }
    }
  }
  for (int i = 2; i < C; i++) {
    pw[i][0] = 1;
    for (int j = 1; j < L; j++) {
      pw[i][j] = pw[i][j - 1] * i;
      if (pw[i][j] > inf) pw[i][j] = inf;
    }
  }
  int t, cs = 0; cin >> t;
  while (t--) {
    ll l, r, k; cin >> l >> r >> k;
    ll ans = backtrack(r, k);
    ans -= backtrack(l - 1, k);
    cout << "Case " << ++cs << ": " << ans << '\n';
  }
  return 0;
}
// https://algo.codemarshal.org/contests/mist-ncpc-2020/problems/E
